/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.network.toserver;

import de.unhappycodings.quarry.common.blockentity.QuarryBlockEntity;
import de.unhappycodings.quarry.common.network.PacketHandler;
import de.unhappycodings.quarry.common.network.base.IPacket;
import de.unhappycodings.quarry.common.network.toclient.QuarryClientBooleanPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class QuarryBooleanPacket
implements IPacket {
    private final BlockPos pos;
    private final boolean refresh;
    private final String type;

    public QuarryBooleanPacket(BlockPos pos, boolean refresh, String type) {
        this.pos = pos;
        this.refresh = refresh;
        this.type = type;
    }

    public static QuarryBooleanPacket decode(FriendlyByteBuf buffer) {
        return new QuarryBooleanPacket(buffer.m_130135_(), buffer.readBoolean(), buffer.m_130277_());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        BlockEntity machine = player.m_20193_().m_7702_(this.pos);
        if (!(machine instanceof QuarryBlockEntity)) {
            return;
        }
        QuarryBlockEntity blockEntity = (QuarryBlockEntity)machine;
        if (this.type.contains("locked")) {
            if (!this.refresh) {
                blockEntity.setLocked(!blockEntity.getLocked());
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), !blockEntity.getLocked(), "locked"), player);
            } else {
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), blockEntity.getLocked(), "locked"), player);
            }
        } else if (this.type.contains("loop")) {
            if (!this.refresh) {
                blockEntity.setLoop(!blockEntity.getLoop());
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), !blockEntity.getLoop(), "loop"), player);
            } else {
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), blockEntity.getLoop(), "loop"), player);
            }
        } else if (this.type.contains("filter")) {
            if (!this.refresh) {
                blockEntity.setFilter(!blockEntity.getFilter());
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), !blockEntity.getFilter(), "filter"), player);
            } else {
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), blockEntity.getFilter(), "filter"), player);
            }
        } else if (this.type.contains("skip")) {
            if (!this.refresh) {
                blockEntity.setSkip(!blockEntity.getSkip());
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), !blockEntity.getSkip(), "skip"), player);
            } else {
                PacketHandler.sendToClient(new QuarryClientBooleanPacket(machine.m_58899_(), blockEntity.getSkip(), "skip"), player);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.refresh);
        buffer.m_130070_(this.type);
    }
}

